{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 14.08.98 - 21:45:58 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  MMSystem,
  MMObj,
  MMRegs,
  MMACMDlg,
  MMPCMSup,
  MMUtils,
  MMCstDlg,
  MMDesign,
  MMWave,
  MMWavOut,
  MMDIBCv,
  MMLevel,
  MMConect,
  MMDSPObj,
  MMWavIn,
  MMRingBf,
  MMHTimer,
  MMSlider,
  MMDSWOut,
  MMHook;

type
  TForm1 = class(TForm)
    WaveIn: TMMWaveIn;
    MMConnector1: TMMConnector;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    MMConnector2: TMMConnector;
    WaveOut: TMMWaveOut;
    RecFile: TMMWaveFile;
    PlayFile: TMMWaveFile;
    MMDesigner1: TMMDesigner;
    Label1: TLabel;
    StopBtn: TButton;
    PlayBtn: TButton;
    RecBtn: TButton;
    OpenDialog: TMMWaveOpenDialog;
    SaveDialog: TMMWaveSaveDialog;
    MMRingBuffer1: TMMRingBuffer;
    PlayRingBuffer: TMMRingBuffer;
    Label2: TLabel;
    Label3: TLabel;
    Timer: TMMHiTimer;
    TrackBar: TMMSlider;
    procedure PlayBtnClick(Sender: TObject);
    procedure DeviceStart(Sender: TObject);
    procedure DeviceStop(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure RecBtnClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure TrackBarTrack(Sender: TObject);
    procedure TrackBarTrackEnd(Sender: TObject);
  private
    Seeking,Playing: Boolean;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{==============================================================================}
function acmBuildGSM610Header(SampleRate: integer): PGSM610WaveFormat;
begin
   Result := GlobalAllocMem(sizeOf(TGSM610WaveFormat));
   with Result^ do
   begin
      wfx.wFormatTag     := WAVE_FORMAT_GSM610;
      wfx.nChannels      := 1;
      wfx.nSamplesPerSec := SampleRate;
      wfx.wBitsPerSample := 0;
      wfx.nAvgBytesPerSec:= 0;
      wfx.nBlockAlign    := 65;
      wfx.cbSize         := 2;
      wSamplesPerBlock   := 320;

      case SampleRate of
         8000 : wfx.nAvgBytesPerSec := 1625;
         11025: wfx.nAvgBytesPerSec := 2239;
         22050: wfx.nAvgBytesPerSec := 4478;
         44100: wfx.nAvgBytesPerSec := 8957;
      end;
   end;
end;

{==============================================================================}
procedure TForm1.StopBtnClick(Sender: TObject);
begin
   { close and stop all devices }
   WaveIn.Stop;
   WaveOut.Stop;
end;

{==============================================================================}
procedure TForm1.PlayBtnClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      PlayFile.Wave.FileName := OpenDialog.FileName;
      TrackBar.MaxValue := PlayFile.Wave.DataSize;

      Playing := True;
      Seeking := False;
      { start playing }
      WaveOut.Start;
   end;
end;

{==============================================================================}
procedure TForm1.RecBtnClick(Sender: TObject);
var
   pwfx: PGSM610WaveFormat;

begin
   if SaveDialog.Execute then
   begin
      Playing := False;

      { set the filename }
      RecFile.Wave.FileName := SaveDialog.FileName;

      { build a GSM Format }
      pwfx := acmBuildGSM610Header(8000);
      try
         { set our WaveFormat }
         WaveIn.PWaveFormat := PWaveFormatEx(pwfx);
      finally
         { finally free the format (WaveIn makes a copy) }
         GlobalFreeMem(Pointer(pwfx));
      end;

      { start recording }
      WaveIn.Start;
   end;
end;

{==============================================================================}
procedure TForm1.DeviceStart(Sender: TObject);
begin
   StopBtn.Enabled := True;
   PlayBtn.Enabled := False;
   RecBtn.Enabled := False;
   Timer.Enabled := True;
end;

{==============================================================================}
procedure TForm1.DeviceStop(Sender: TObject);
begin
   Playing := False;
   Timer.Enabled := False;

   StopBtn.Enabled := False;
   PlayBtn.Enabled := True;
   RecBtn.Enabled := True;

   WaveIn.Close;
   WaveOut.Close;
end;

{==============================================================================}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   { don't forgot to close the devices at the end }
   WaveIn.Close;
   WaveOut.Close;
end;

{==============================================================================}
procedure TForm1.TimerTimer(Sender: TObject);
var
   Time: Longint;
begin
   if Playing then
   begin
      Time := WaveOut.Position;
      if not Seeking then TrackBar.Position:= PlayFile.Wave.Position;
   end
   else
      Time := WaveIn.Position;
   Label1.Caption := TimeToString(Time);
end;

{==============================================================================}
procedure TForm1.TrackBarTrack(Sender: TObject);
begin
   Seeking := True;
end;

{==============================================================================}
procedure TForm1.TrackBarTrackEnd(Sender: TObject);
begin
   if Playing then
   begin
      WaveOut.Pause;
      PlayFile.Wave.Position := TrackBar.Position;
      PlayRingBuffer.Clear;
      WaveOut.Reset;
      WaveOut.Restart;
   end;
   Seeking := False;
end;


end.
